USE AdventureWorks2014
GO
SELECT 
    s.[BusinessEntityID] 
    ,s.[Name] 
    ,ct.[Name] AS [ContactType] 
    ,p.[Title] 
    ,p.[FirstName] 
    ,p.[MiddleName] 
    ,p.[LastName] 
    ,p.[Suffix] 
    ,pp.[PhoneNumber] 
	,pnt.[Name] AS [PhoneNumberType]
    ,ea.[EmailAddress] 
    ,p.[EmailPromotion] 
FROM [Sales].[Store] s
INNER JOIN [Person].[BusinessEntityContact] bec 
    ON bec.[BusinessEntityID] = s.[BusinessEntityID]
INNER JOIN [Person].[ContactType] ct
	ON ct.[ContactTypeID] = bec.[ContactTypeID]
INNER JOIN [Person].[Person] p
	ON p.[BusinessEntityID] = bec.[PersonID]
LEFT OUTER JOIN [Person].[EmailAddress] ea
	ON ea.[BusinessEntityID] = p.[BusinessEntityID]
LEFT OUTER JOIN [Person].[PersonPhone] pp
	ON pp.[BusinessEntityID] = p.[BusinessEntityID]
LEFT OUTER JOIN [Person].[PhoneNumberType] pnt
	ON pnt.[PhoneNumberTypeID] = pp.[PhoneNumberTypeID];



















--------------------------------------------------------------------------------------
DECLARE @SQL nvarchar(1000)
SET @SQL = 
	'SELECT													' +
	'    s.[BusinessEntityID] 								' +
	'    ,s.[Name] 											' +
	'    ,ct.[Name] AS [ContactType] 						' +
	'    ,p.[Title] 										' +
	'    ,p.[FirstName] 									' +
	'    ,p.[MiddleName] 									' +
	'    ,p.[LastName] 										' +
	'    ,p.[Suffix] 										' +
	'    ,pp.[PhoneNumber] 									' +
	'	,pnt.[Name] AS [PhoneNumberType]					' +
	'    ,ea.[EmailAddress] 								' +
	'    ,p.[EmailPromotion] 								' +
	'FROM [Sales].[Store] s									' +
	'INNER JOIN [Person].[BusinessEntityContact] bec 		' +
	'    ON bec.[BusinessEntityID] = s.[BusinessEntityID]	' +
	'INNER JOIN [Person].[ContactType] ct					' +
	'	ON ct.[ContactTypeID] = bec.[ContactTypeID]			' +
	'INNER JOIN [Person].[Person] p							' +
	'	ON p.[BusinessEntityID] = bec.[PersonID]			' +
	'LEFT OUTER JOIN [Person].[EmailAddress] ea				' +
	'	ON ea.[BusinessEntityID] = p.[BusinessEntityID]		' +
	'LEFT OUTER JOIN [Person].[PersonPhone] pp				' +
	'	ON pp.[BusinessEntityID] = p.[BusinessEntityID]		' +
	'LEFT OUTER JOIN [Person].[PhoneNumberType] pnt			' +
	'	ON pnt.[PhoneNumberTypeID] = pp.[PhoneNumberTypeID];' 

PRINT @SQL
GO




















--------------------------------------------------------------------------------------
DECLARE @SQL nvarchar(1000)
SET @SQL = 
	'SELECT													' + CHAR(13) +
	'    s.[BusinessEntityID] 								' + CHAR(13) +
	'    ,s.[Name] 											' + CHAR(13) +
	'    ,ct.[Name] AS [ContactType] 						' + CHAR(13) +
	'    ,p.[Title] 										' + CHAR(13) +
	'    ,p.[FirstName] 									' + CHAR(13) +
	'    ,p.[MiddleName] 									' + CHAR(13) +
	'    ,p.[LastName] 										' + CHAR(13) +
	'    ,p.[Suffix] 										' + CHAR(13) +
	'    ,pp.[PhoneNumber] 									' + CHAR(13) +
	'	,pnt.[Name] AS [PhoneNumberType]					' + CHAR(13) +
	'    ,ea.[EmailAddress] 								' + CHAR(13) +
	'    ,p.[EmailPromotion] 								' + CHAR(13) +
	'FROM [Sales].[Store] s									' + CHAR(13) +
	'INNER JOIN [Person].[BusinessEntityContact] bec 		' + CHAR(13) +
	'    ON bec.[BusinessEntityID] = s.[BusinessEntityID]	' + CHAR(13) +
	'INNER JOIN [Person].[ContactType] ct					' + CHAR(13) +
	'	ON ct.[ContactTypeID] = bec.[ContactTypeID]			' + CHAR(13) +
	'INNER JOIN [Person].[Person] p							' + CHAR(13) +
	'	ON p.[BusinessEntityID] = bec.[PersonID]			' + CHAR(13) +
	'LEFT OUTER JOIN [Person].[EmailAddress] ea				' + CHAR(13) +
	'	ON ea.[BusinessEntityID] = p.[BusinessEntityID]		' + CHAR(13) +
	'LEFT OUTER JOIN [Person].[PersonPhone] pp				' + CHAR(13) +
	'	ON pp.[BusinessEntityID] = p.[BusinessEntityID]		' + CHAR(13) +
	'LEFT OUTER JOIN [Person].[PhoneNumberType] pnt			' + CHAR(13) +
	'	ON pnt.[PhoneNumberTypeID] = pp.[PhoneNumberTypeID];' 

PRINT @SQL
GO



















--------------------------------------------------------------------------------------
DECLARE @SQL nvarchar(1000)
SET @SQL = 
'SELECT 
    s.[BusinessEntityID] 
    ,s.[Name] 
    ,ct.[Name] AS [ContactType] 
    ,p.[Title] 
    ,p.[FirstName] 
    ,p.[MiddleName] 
    ,p.[LastName] 
    ,p.[Suffix] 
    ,pp.[PhoneNumber] 
	,pnt.[Name] AS [PhoneNumberType]
    ,ea.[EmailAddress] 
    ,p.[EmailPromotion] 
FROM [Sales].[Store] s
INNER JOIN [Person].[BusinessEntityContact] bec 
    ON bec.[BusinessEntityID] = s.[BusinessEntityID]
INNER JOIN [Person].[ContactType] ct
	ON ct.[ContactTypeID] = bec.[ContactTypeID]
INNER JOIN [Person].[Person] p
	ON p.[BusinessEntityID] = bec.[PersonID]
LEFT OUTER JOIN [Person].[EmailAddress] ea
	ON ea.[BusinessEntityID] = p.[BusinessEntityID]
LEFT OUTER JOIN [Person].[PersonPhone] pp
	ON pp.[BusinessEntityID] = p.[BusinessEntityID]
LEFT OUTER JOIN [Person].[PhoneNumberType] pnt
	ON pnt.[PhoneNumberTypeID] = pp.[PhoneNumberTypeID];'

PRINT @SQL
GO
